
#|________________
 |
 |WORKBAR FUNCTION
 |__________________
 |#

(defun workbar (&key (in nil in?) (title "ViSta WorkSpace") 
                     (show t) (size (if *devel-mode* '(550 52) '(444 52)))
                     (location '(50 50)) (pop-out nil))
  (let* ((*mbc* (container :in in :localmenu t :toolwindow t ;in nil
                           :title title :show show
                           :size size :location location))
         (setf *wm* (workmap))
         (setv *tb* (toolbox *wm*))
         )
    (send *mbc* :add-slot 'menus (add-menubar :container *mbc*))
    (send *mbc* :top-most t)
    (send *wm* :show-window)
    (send *wm* :top-most t)
    (send *wm* :location -1 2)
    (defmeth *wm* :size (&rest args)
      (send (send *wm* :container) :size args)
      (call-next-method args))

    (defmeth *wm* :size (&rest args)
      (apply #'call-next-method args))

    (defmeth iconmap-proto :size (&rest args)
      (apply #'call-next-method args))

    (defmeth *wm* :resize (&rest args)
      (apply #'call-next-method args))

    (defmeth iconmap-proto :resize (&rest args)
      (apply #'call-next-method args))

    (apply #' send *wm* :size (screen-size))

    (mapcar #'(lambda (slot)
                (if (send *wm* :slot-value slot)
                    (send *wm* :slot-value slot (send *wm* :slot-value slot))
                    (send *wm* :slot-value slot (send *workmap* :slot-value slot)))
                )
            (send *wm* :own-slots))
    (send *vista* :show-toolbar)
    (send *tb* :draw-toolbar)
    (show-toolbar *wm* *tb*)
    (send *vista* :show-toolbar)
    (send *wm* :toolbar t)
    
    (mapcar #'(lambda (slot)
                (if (send *tb* :slot-value slot)
                    (send *tb* :slot-value slot (send *tb* :slot-value slot))
                    (send *tb* :slot-value slot (send *toolbar* :slot-value slot)))
                )
            (send *tb* :own-slots))
    
    
    (mapcar #'(lambda (slot)
            (send *tb* :slot-value slot (send *toolbox* :slot-value slot))
                )
        (list
         'num-icons 'icon-list 'analysis-symbol-list 'button-name-list 
         'data-types-list  'x 'y 
         'num-icons-shown 'data-types-master 'analysis-symbols-master
         'enable-soft-buttons 'soft-button-titles 'hard-button-name-list
         'button-name-master 'icon-list-master 'analyze-menu-item-name-master))
    
    

    (defmeth *mbc* :redraw ()
      (call-next-method)
      ;(send *wm* :redraw-overlays)
      (send *tb* :draw-toolbar))

    (defmeth *mbc* :size (&rest args)
      (let* ((w (max (if *devel-mode* 550 444) 
                     (1+ (send *workmap* :toolbar-length))))     )
        (call-next-method w 53)))
    
    (defmeth *mbc* :resize () (send self :size ))
    (send *mbc* :redraw)
    (send *tb* :redraw)
    *wm*))



#|#__________________
 |
 |WORKBAR PROGRAM
 |__________________
#|#


#|

(setf *mbc* (container :in nil :localmenu t :toolwindow t
                       :title "ViSta ToolBar" :show t :style 0
                       :size (if *devel-mode* '(550 54) '(444 54))
                       :location  '(50 50)))
(send *mbc* :add-slot 'menus (add-menubar :container *mbc*))
(send *mbc* :top-most t)
(enable-container *mbc* )

(setf *wm* (workmap))

(send *wm* :show-window)
(send *wm* :bottom-most t)
(send *wm* :top-most nil)
(send *wm* :location -1 2)
(send *wm* :no-move t)

(defmeth *wm* :size (&rest args)
(apply #'call-next-method args))

(defmeth iconmap-proto :size (&rest args)
(apply #'call-next-method args))

(defmeth *wm* :resize (&rest args)
(apply #'call-next-method args))

(defmeth iconmap-proto :resize (&rest args)
(apply #'call-next-method args))

(apply #' send *wm* :size (screen-size))

(mapcar #'(lambda (slot)
              (if (send *wm* :slot-value slot)
                  (send *wm* :slot-value slot (send *wm* :slot-value slot))
                  (send *wm* :slot-value slot (send *workmap* :slot-value slot)))
              )
          (send *wm* :own-slots))
;(send *wm* :back-color 'blue)

;===============NEW

(enable-container *mbc* )
(setf *wm2* (workmap))

(send *wm2* :show-window)
(send *wm2* :top-most t)
(send *wm2* :bottom-most nil)
(send *wm*  :top-most nil)
(send *wm*  :bottom-most t)
(send *wm2* :location -1 2)
(send *wm2* :back-color 'red)

(defmeth *wm2* :size (&rest args)
(apply #'call-next-method args))

(send *wm2* :size (first (screen-size)) 24)

(setf *tb* (toolbox *wm2*))

(send *vista* :show-toolbar)
(send *tb* :draw-toolbar)
(show-toolbar *wm2* *tb*)
(send *vista* :show-toolbar)
(send *wm2* :toolbar t)
(mapcar #'(lambda (slot)
              (if (send *wm2* :slot-value slot)
                  (send *wm2* :slot-value slot (send *wm2* :slot-value slot))
                  (send *wm2* :slot-value slot (send *workmap* :slot-value slot)))
              )
          (send *wm2* :own-slots))
(send *wm2* :size (first (send *mbc* :size)) 24)

(mapcar #'(lambda (slot)
              (if (send *tb* :slot-value slot)
                  (send *tb* :slot-value slot (send *tb* :slot-value slot))
                  (send *tb* :slot-value slot (send *toolbar* :slot-value slot)))
              )
          (send *tb* :own-slots))

 

(mapcar #'(lambda (slot)
            (send *tb* :slot-value slot (send *toolbox* :slot-value slot))
            )
        (list
         'num-icons 'icon-list 'analysis-symbol-list 'button-name-list 
         'data-types-list  'x 'y 
         'num-icons-shown 'data-types-master 'analysis-symbols-master
         'enable-soft-buttons 'soft-button-titles 'hard-button-name-list
         'button-name-master 'icon-list-master 'analyze-menu-item-name-master))

(send *wm2* :location 2 24)

(defmeth *mbc* :redraw ()
  (call-next-method)
  ;(send *wm* :redraw-overlays)
  (send *tb* :draw-toolbar))



(defmeth *mbc* :size (&rest args)
   (apply #'call-next-method args))


(defmeth *mbc* :resize ()
  (call-next-method))
  ;(apply #'send *wm* :size (send self :size)))
  ;(send *wm2* :size (first (send self :size)) 8))
|#